/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import noppes.npcs.client.gui.util.LineData;
import noppes.npcs.client.gui.util.MarkUp;
import noppes.npcs.config.TrueTypeFont;

public class TextContainer {
    public static boolean colored = true;
    public Pattern regexString = Pattern.compile("([\"'])(?:\\\\.|[^\"'])*?\\1", 8);
    public Pattern regexFunction = Pattern.compile("\\b(if|else|switch|with|for|while|in|var|const|let|throw|then|function|continue|break|foreach|return|try|catch|finally|do|this|typeof|instanceof|new)(?=\\W)");
    public Pattern regexWord = Pattern.compile("(\\p{L}+\\.?|[./,:;!|])+|\n|$");
    public Pattern regexNumber = Pattern.compile("\\b-?(?:0[xX][\\dA-Fa-f]+|0[bB][01]+|0[oO][0-7]+|\\d*\\.?\\d+(?:[Ee][+-]?\\d+)?[fFbBdDlLsS]?|NaN|null|Infinity|unidentified|true|false)\\b");
    public Pattern regexComment = Pattern.compile("/\\*[\\s\\S]*?(?:\\*/|$)|//.*|#.*");
    public String text;
    public List<MarkUp> makeup = new ArrayList<MarkUp>();
    public List<LineData> lines = new ArrayList<LineData>();
    public int visibleLines = 1;
    public int lineHeight;
    public int totalHeight;
    public int linesCount;
    private final Map<String, Integer> hash = new HashMap<String, Integer>();
    private final TrueTypeFont font;
    private final int width;
    private final int height;
    private boolean lighting;

    public TextContainer(String textIn, TrueTypeFont fontIn, int widthIn, int heightIn, boolean lightingIn) {
        this.text = textIn.replaceAll("\\r?\\n|\\r", "\n");
        this.font = fontIn;
        this.width = widthIn;
        this.height = heightIn;
        this.lighting = lightingIn;
    }

    public TextContainer copy() {
        TextContainer container = new TextContainer(this.text, this.font, this.width, this.height, this.lighting);
        container.text = this.text;
        for (MarkUp mark : new ArrayList<MarkUp>(this.makeup)) {
            container.makeup.add(new MarkUp(mark.start, mark.end, mark.c, mark.level));
        }
        for (LineData line : new ArrayList<LineData>(this.lines)) {
            container.lines.add(new LineData(line.text, line.start, line.end));
        }
        container.visibleLines = this.visibleLines;
        container.lineHeight = this.lineHeight;
        container.totalHeight = this.totalHeight;
        container.linesCount = this.linesCount;
        return container;
    }

    public void setLighting(boolean lightingIn) {
        this.lighting = lightingIn;
        if (this.lighting) {
            this.formatCodeText();
        }
    }

    public boolean compareMarkUps(MarkUp mu1, MarkUp mu2) {
        return mu1 == null || mu1.start > mu2.start;
    }

    public void formatCodeText() {
        MarkUp markup;
        if (!colored) {
            return;
        }
        this.makeup.clear();
        int start = 0;
        while ((markup = this.getNextMatching(start)) != null) {
            this.makeup.add(markup);
            start = markup.end;
        }
    }

    private MarkUp getNextMatching(int start) {
        MarkUp markup2;
        MarkUp markup = null;
        String s = this.text.substring(start);
        Matcher matcher = this.regexNumber.matcher(s);
        if (matcher.find()) {
            markup = new MarkUp(matcher.start(), matcher.end(), '6', 0);
        }
        if ((matcher = this.regexFunction.matcher(s)).find() && this.compareMarkUps(markup, markup2 = new MarkUp(matcher.start(), matcher.end(), '2', 0))) {
            markup = markup2;
        }
        if ((matcher = this.regexString.matcher(s)).find() && this.compareMarkUps(markup, markup2 = new MarkUp(matcher.start(), matcher.end(), '4', 7))) {
            markup = markup2;
        }
        if ((matcher = this.regexComment.matcher(s)).find() && this.compareMarkUps(markup, markup2 = new MarkUp(matcher.start(), matcher.end(), '8', 7))) {
            markup = markup2;
        }
        if (markup != null) {
            markup.start += start;
            markup.end += start;
        }
        return markup;
    }

    public void init() {
        this.lines.clear();
        if (this.lineHeight == 0) {
            this.lineHeight = 12;
        }
        int totalChars = 0;
        for (String l : this.text.split("\n")) {
            StringBuilder line = new StringBuilder();
            int lineWidth = 0;
            Matcher m = this.regexWord.matcher(l);
            int i = 0;
            while (m.find()) {
                String word = l.substring(i, m.start());
                if (lineWidth + this.getWordWidth(word) > this.width - 10) {
                    this.lines.add(new LineData(line.toString(), totalChars, totalChars + line.length()));
                    totalChars += line.length();
                    line = new StringBuilder();
                    lineWidth = 0;
                }
                if (this.getWordWidth(word) > this.width - 10) {
                    StringBuilder w = new StringBuilder();
                    for (int c = 0; c < word.length(); ++c) {
                        if (this.font.width(w.toString() + word.charAt(c)) <= this.width - 10) {
                            w.append(word.charAt(c));
                            continue;
                        }
                        this.lines.add(new LineData(w.toString(), totalChars, totalChars + w.length()));
                        totalChars += w.length();
                        line = new StringBuilder();
                        lineWidth = 0;
                        w = new StringBuilder("" + word.charAt(c));
                    }
                    line.append((CharSequence)w);
                    lineWidth += this.getWordWidth(w.toString());
                } else {
                    line.append(word);
                    lineWidth += this.getWordWidth(word);
                }
                i = m.start();
            }
            this.lines.add(new LineData(line.toString(), totalChars, totalChars + line.length() + 1));
            totalChars += line.length() + 1;
        }
        this.linesCount = this.lines.size();
        this.totalHeight = this.linesCount * this.lineHeight;
        this.visibleLines = Math.max(this.height / this.lineHeight, 1);
        if (this.lighting) {
            this.formatCodeText();
        }
    }

    private int getWordWidth(String word) {
        if (!this.hash.containsKey(word)) {
            this.hash.put(word, this.font.width(word));
        }
        return this.hash.get(word);
    }
}

